
;CodeVisionAVR C Compiler V2.04.4a Advanced
;(C) Copyright 1998-2009 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type                : ATmega8535
;Program type             : Application
;Clock frequency          : 16,000000 MHz
;Memory model             : Small
;Optimize for             : Size
;(s)printf features       : int, width
;(s)scanf features        : int, width
;External RAM size        : 0
;Data Stack size          : 128 byte(s)
;Heap size                : 0 byte(s)
;Promote 'char' to 'int'  : Yes
;'char' is unsigned       : Yes
;8 bit enums              : Yes
;global 'const' stored in FLASH: No
;Enhanced core instructions    : On
;Smart register allocation     : On
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATmega8535
	#pragma AVRPART MEMORY PROG_FLASH 8192
	#pragma AVRPART MEMORY EEPROM 512
	#pragma AVRPART MEMORY INT_SRAM SIZE 512
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60

	.LISTMAC
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU SPSR=0xE
	.EQU SPDR=0xF
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU EEARH=0x1F
	.EQU WDTCR=0x21
	.EQU MCUCR=0x35
	.EQU GICR=0x3B
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	RCALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __GETD1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X+
	LD   R22,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	RCALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _dig_number=R5
	.DEF _dig=R4
	.DEF _simvol=R7
	.DEF _d=R6
	.DEF _stolb=R9
	.DEF _s_stolb=R8
	.DEF _s_char=R11
	.DEF _n_simvol=R10
	.DEF _space=R13
	.DEF _out=R12

	.CSEG
	.ORG 0x00

;INTERRUPT VECTORS
	RJMP __RESET
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00

_led_tab:
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5F
	.DB  0x0,0x0,0x0,0x7,0x0,0x7,0x0,0x14
	.DB  0x7F,0x14,0x7F,0x14,0x24,0x2A,0x7F,0x2A
	.DB  0x12,0x23,0x13,0x8,0x64,0x62,0x36,0x49
	.DB  0x55,0x22,0x50,0x0,0x5,0x3,0x0,0x0
	.DB  0x0,0x1C,0x22,0x41,0x0,0x0,0x41,0x22
	.DB  0x1C,0x0,0x14,0x8,0x3E,0x8,0x14,0x8
	.DB  0x8,0x3E,0x8,0x8,0x0,0x50,0x30,0x0
	.DB  0x0,0x8,0x8,0x8,0x8,0x8,0x0,0x60
	.DB  0x60,0x0,0x0,0x20,0x10,0x8,0x4,0x2
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5F
	.DB  0x0,0x0,0x0,0x7,0x0,0x7,0x0,0x14
	.DB  0x7F,0x14,0x7F,0x14,0x24,0x2A,0x7F,0x2A
	.DB  0x12,0x23,0x13,0x8,0x64,0x62,0x36,0x49
	.DB  0x55,0x22,0x50,0x0,0x5,0x3,0x0,0x0
	.DB  0x0,0x1C,0x22,0x41,0x0,0x0,0x41,0x22
	.DB  0x1C,0x0,0x14,0x8,0x3E,0x8,0x14,0x8
	.DB  0x8,0x3E,0x8,0x8,0x0,0x50,0x30,0x0
	.DB  0x0,0x8,0x8,0x8,0x8,0x8,0x0,0x60
	.DB  0x60,0x0,0x0,0x20,0x10,0x8,0x4,0x2
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5F
	.DB  0x0,0x0,0x0,0x7,0x0,0x7,0x0,0x14
	.DB  0x7F,0x14,0x7F,0x14,0x24,0x2A,0x7F,0x2A
	.DB  0x12,0x23,0x13,0x8,0x64,0x62,0x36,0x49
	.DB  0x55,0x22,0x50,0x0,0x5,0x3,0x0,0x0
	.DB  0x0,0x1C,0x22,0x41,0x0,0x0,0x41,0x22
	.DB  0x1C,0x0,0x14,0x8,0x3E,0x8,0x14,0x8
	.DB  0x8,0x3E,0x8,0x8,0x0,0x50,0x30,0x0
	.DB  0x0,0x8,0x8,0x8,0x8,0x8,0x0,0x60
	.DB  0x60,0x0,0x0,0x20,0x10,0x8,0x4,0x2
	.DB  0x3E,0x51,0x49,0x45,0x3E,0x0,0x42,0x7F
	.DB  0x40,0x0,0x42,0x61,0x51,0x49,0x46,0x21
	.DB  0x41,0x45,0x4B,0x31,0x18,0x14,0x12,0x7F
	.DB  0x10,0x27,0x45,0x45,0x45,0x39,0x3C,0x4A
	.DB  0x49,0x49,0x30,0x1,0x71,0x9,0x5,0x3
	.DB  0x36,0x49,0x49,0x49,0x36,0x6,0x49,0x49
	.DB  0x29,0x1E,0x0,0x36,0x36,0x0,0x0,0x0
	.DB  0x56,0x36,0x0,0x0,0x8,0x14,0x22,0x41
	.DB  0x0,0x14,0x14,0x14,0x14,0x14,0x0,0x41
	.DB  0x22,0x14,0x8,0x2,0x1,0x51,0x9,0x6
	.DB  0x32,0x49,0x79,0x41,0x3E,0x7E,0x11,0x11
	.DB  0x11,0x7E,0x7F,0x49,0x49,0x49,0x36,0x3E
	.DB  0x41,0x41,0x41,0x22,0x7F,0x41,0x41,0x22
	.DB  0x1C,0x7F,0x49,0x49,0x49,0x41,0x7F,0x9
	.DB  0x9,0x9,0x1,0x3E,0x41,0x49,0x49,0x7A
	.DB  0x7F,0x8,0x8,0x8,0x7F,0x0,0x41,0x7F
	.DB  0x41,0x0,0x20,0x40,0x41,0x3F,0x1,0x7F
	.DB  0x8,0x14,0x22,0x41,0x7F,0x40,0x40,0x40
	.DB  0x40,0x7F,0x2,0xC,0x2,0x7F,0x7F,0x4
	.DB  0x8,0x10,0x7F,0x3E,0x41,0x41,0x41,0x3E
	.DB  0x7F,0x9,0x9,0x9,0x6,0x3E,0x41,0x51
	.DB  0x21,0x5E,0x7F,0x9,0x19,0x29,0x46,0x46
	.DB  0x49,0x49,0x49,0x31,0x1,0x1,0x7F,0x1
	.DB  0x1,0x3F,0x40,0x40,0x40,0x3F,0x1F,0x20
	.DB  0x40,0x20,0x1F,0x3F,0x40,0x38,0x40,0x3F
	.DB  0x63,0x14,0x8,0x14,0x63,0x7,0x8,0x70
	.DB  0x8,0x7,0x61,0x51,0x49,0x45,0x43,0x0
	.DB  0x7F,0x41,0x41,0x0,0x2,0x4,0x8,0x10
	.DB  0x20,0x0,0x41,0x41,0x7F,0x0,0x4,0x2
	.DB  0x1,0x2,0x4,0x40,0x40,0x40,0x40,0x40
	.DB  0x0,0x6,0x9,0x9,0x6,0x20,0x54,0x54
	.DB  0x54,0x78,0x7F,0x48,0x44,0x44,0x38,0x38
	.DB  0x44,0x44,0x44,0x20,0x38,0x44,0x44,0x48
	.DB  0x7F,0x38,0x54,0x54,0x54,0x18,0x8,0x7E
	.DB  0x9,0x1,0x2,0xC,0x52,0x52,0x52,0x3E
	.DB  0x7F,0x8,0x4,0x4,0x78,0x0,0x44,0x7D
	.DB  0x40,0x0,0x20,0x40,0x44,0x3D,0x0,0x7F
	.DB  0x10,0x28,0x44,0x0,0x0,0x41,0x7F,0x40
	.DB  0x0,0x7C,0x4,0x18,0x4,0x78,0x7C,0x8
	.DB  0x4,0x4,0x78,0x38,0x44,0x44,0x44,0x38
	.DB  0x7C,0x14,0x14,0x14,0x8,0x8,0x14,0x14
	.DB  0x18,0x7C,0x7C,0x8,0x4,0x4,0x8,0x8
	.DB  0x54,0x54,0x54,0x20,0x4,0x3F,0x44,0x40
	.DB  0x20,0x3C,0x40,0x40,0x20,0x7C,0x1C,0x20
	.DB  0x40,0x20,0x1C,0x3C,0x40,0x30,0x40,0x3C
	.DB  0x44,0x28,0x10,0x28,0x44,0xC,0x50,0x50
	.DB  0x50,0x3C,0x44,0x64,0x54,0x4C,0x44,0x0
	.DB  0x8,0x36,0x41,0x0,0x0,0x0,0x7F,0x0
	.DB  0x0,0x0,0x41,0x36,0x8,0x0,0x10,0x8
	.DB  0x8,0x10,0x8,0x78,0x46,0x41,0x46,0x78
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5F
	.DB  0x0,0x0,0x0,0x7,0x0,0x7,0x0,0x14
	.DB  0x7F,0x14,0x7F,0x14,0x24,0x2A,0x7F,0x2A
	.DB  0x12,0x23,0x13,0x8,0x64,0x62,0x36,0x49
	.DB  0x55,0x22,0x50,0x0,0x5,0x3,0x0,0x0
	.DB  0x0,0x1C,0x22,0x41,0x0,0x0,0x41,0x22
	.DB  0x1C,0x0,0x14,0x8,0x3E,0x8,0x14,0x8
	.DB  0x8,0x3E,0x8,0x8,0x0,0x50,0x30,0x0
	.DB  0x0,0x8,0x8,0x8,0x8,0x8,0x0,0x60
	.DB  0x60,0x0,0x0,0x20,0x10,0x8,0x4,0x2
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5F
	.DB  0x0,0x0,0x0,0x7,0x0,0x7,0x0,0x14
	.DB  0x7F,0x14,0x7F,0x14,0x24,0x2A,0x7F,0x2A
	.DB  0x12,0x23,0x13,0x8,0x64,0x62,0x36,0x49
	.DB  0x55,0x22,0x50,0x0,0x5,0x3,0x0,0x0
	.DB  0x0,0x1C,0x22,0x41,0x0,0x0,0x41,0x22
	.DB  0x1C,0x0,0x14,0x8,0x3E,0x8,0x14,0x8
	.DB  0x8,0x3E,0x8,0x8,0x0,0x50,0x30,0x0
	.DB  0x0,0x8,0x8,0x8,0x8,0x8,0x0,0x60
	.DB  0x60,0x0,0x0,0x20,0x10,0x8,0x4,0x2
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5F
	.DB  0x0,0x0,0x0,0x7,0x0,0x7,0x0,0x14
	.DB  0x7F,0x14,0x7F,0x14,0x24,0x2A,0x7F,0x2A
	.DB  0x12,0x23,0x13,0x8,0x64,0x62,0x36,0x49
	.DB  0x55,0x22,0x50,0x0,0x5,0x3,0x0,0x0
	.DB  0x0,0x1C,0x22,0x41,0x0,0x0,0x41,0x22
	.DB  0x1C,0x0,0x14,0x8,0x3E,0x8,0x14,0x8
	.DB  0x8,0x3E,0x8,0x8,0x0,0x50,0x30,0x0
	.DB  0x0,0x8,0x8,0x8,0x8,0x8,0x0,0x60
	.DB  0x60,0x0,0x0,0x20,0x10,0x8,0x4,0x2
	.DB  0x0,0x6,0x9,0x9,0x6,0x0,0x42,0x7F
	.DB  0x40,0x0,0x42,0x61,0x51,0x49,0x46,0x21
	.DB  0x41,0x45,0x4B,0x31,0x18,0x14,0x12,0x7F
	.DB  0x10,0x27,0x45,0x45,0x45,0x39,0x3C,0x4A
	.DB  0x49,0x49,0x30,0x1,0x71,0x9,0x5,0x3
	.DB  0x36,0x49,0x49,0x49,0x36,0x6,0x49,0x49
	.DB  0x29,0x1E,0x0,0x36,0x36,0x0,0x0,0x0
	.DB  0x56,0x36,0x0,0x0,0x8,0x14,0x22,0x41
	.DB  0x0,0x14,0x14,0x14,0x14,0x14,0x0,0x41
	.DB  0x22,0x14,0x8,0x2,0x1,0x51,0x9,0x6
	.DB  0x7E,0x11,0x11,0x11,0x7E,0x7F,0x49,0x49
	.DB  0x49,0x31,0x7F,0x49,0x49,0x49,0x36,0x7F
	.DB  0x1,0x1,0x1,0x3,0x60,0x3E,0x21,0x21
	.DB  0x7F,0x7F,0x49,0x49,0x49,0x41,0x77,0x8
	.DB  0x7F,0x8,0x77,0x22,0x41,0x49,0x49,0x36
	.DB  0x7F,0x10,0x8,0x4,0x7F,0x7F,0x10,0x9
	.DB  0x4,0x7F,0x7F,0x8,0x14,0x22,0x41,0x40
	.DB  0x3E,0x1,0x1,0x7F,0x7F,0x2,0xC,0x2
	.DB  0x7F,0x7F,0x8,0x8,0x8,0x7F,0x3E,0x41
	.DB  0x41,0x41,0x3E,0x7F,0x1,0x1,0x1,0x7F
	.DB  0x7F,0x9,0x9,0x9,0x6,0x3E,0x41,0x41
	.DB  0x41,0x22,0x1,0x1,0x7F,0x1,0x1,0x27
	.DB  0x48,0x48,0x48,0x3F,0x1E,0x21,0x7F,0x21
	.DB  0x1E,0x63,0x14,0x8,0x14,0x63,0x3F,0x20
	.DB  0x20,0x3F,0x60,0x7,0x8,0x8,0x8,0x7F
	.DB  0x7F,0x40,0x7F,0x40,0x7F,0x3F,0x20,0x3F
	.DB  0x20,0x7F,0x1,0x7F,0x48,0x48,0x30,0x7F
	.DB  0x48,0x30,0x0,0x7F,0x0,0x7F,0x48,0x48
	.DB  0x30,0x22,0x41,0x49,0x49,0x3E,0x7F,0x8
	.DB  0x3E,0x41,0x3E,0x46,0x29,0x19,0x9,0x7F
	.DB  0x20,0x54,0x54,0x54,0x78,0x3C,0x4A,0x4A
	.DB  0x4A,0x30,0x7C,0x54,0x54,0x28,0x0,0x7C
	.DB  0x4,0x4,0x4,0x4,0x60,0x38,0x24,0x24
	.DB  0x7C,0x38,0x54,0x54,0x54,0x18,0x6C,0x10
	.DB  0x7C,0x10,0x6C,0x0,0x44,0x54,0x54,0x28
	.DB  0x7C,0x20,0x10,0x8,0x7C,0x7C,0x21,0x12
	.DB  0x9,0x7C,0x7C,0x10,0x28,0x44,0x0,0x40
	.DB  0x38,0x4,0x4,0x7C,0x7C,0x8,0x10,0x8
	.DB  0x7C,0x7C,0x10,0x10,0x10,0x7C,0x38,0x44
	.DB  0x44,0x44,0x38,0x7C,0x4,0x4,0x4,0x7C
	.DB  0x7C,0x14,0x14,0x14,0x8,0x38,0x44,0x44
	.DB  0x44,0x0,0x4,0x4,0x7C,0x4,0x4,0xC
	.DB  0x50,0x50,0x50,0x3C,0x8,0x14,0x7C,0x14
	.DB  0x8,0x44,0x28,0x10,0x28,0x44,0x3C,0x20
	.DB  0x20,0x3C,0x60,0xC,0x10,0x10,0x10,0x7C
	.DB  0x7C,0x40,0x7C,0x40,0x7C,0x3C,0x20,0x3C
	.DB  0x20,0x7C,0x4,0x7C,0x50,0x50,0x20,0x7C
	.DB  0x50,0x20,0x0,0x7C,0x0,0x7C,0x50,0x50
	.DB  0x20,0x28,0x44,0x54,0x54,0x38,0x7C,0x10
	.DB  0x38,0x44,0x38,0x48,0x54,0x34,0x14,0x7C
_tbl10_G100:
	.DB  0x10,0x27,0xE8,0x3,0x64,0x0,0xA,0x0
	.DB  0x1,0x0
_tbl16_G100:
	.DB  0x0,0x10,0x0,0x1,0x10,0x0,0x1,0x0

_0x3:
	.DB  0x1
_0x41:
	.DB  0x5,0x30,0x0,0xA

__GLOBAL_INI_TBL:
	.DW  0x01
	.DW  _i
	.DW  _0x3*2

	.DW  0x04
	.DW  0x08
	.DW  _0x41*2

_0xFFFFFFFF:
	.DW  0

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  GICR,R31
	OUT  GICR,R30
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(0x200)
	LDI  R25,HIGH(0x200)
	LDI  R26,0x60
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;STACK POINTER INITIALIZATION
	LDI  R30,LOW(0x25F)
	OUT  SPL,R30
	LDI  R30,HIGH(0x25F)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(0xE0)
	LDI  R29,HIGH(0xE0)

	RJMP _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0xE0

	.CSEG
;/*****************************************************
;This program was produced by the
;CodeWizardAVR V2.05.0 Professional
;Automatic Program Generator
; Copyright 1998-2010 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com
;
;Project :
;Version :
;Date    : 17.12.2012
;Author  : NeVaDa
;Company :
;Comments:
;
;
;Chip type               : ATmega8535
;Program type            : Application
;AVR Core Clock frequency: 16,000000 MHz
;Memory model            : Small
;External RAM size       : 0
;Data Stack size         : 128
;*****************************************************/
;
;#include <mega8535.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x40
	.EQU __sm_mask=0xB0
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0xA0
	.EQU __sm_ext_standby=0xB0
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif
;
;#include <delay.h>
;// Standard Input/Output functions
;#include <stdio.h>
;
;#define SH PORTB.2     // 
;#define ST PORTB.0   // 
;#define DS PORTB.1    // 
;#define LED PORTD.7    //  
;#define btn_m PINC.7    //MENU
;
;flash unsigned char led_tab[][5]={
;0x00, 0x00, 0x00, 0x00, 0x00,// 00
;0x00, 0x00, 0x5F, 0x00, 0x00,// 01
;0x00, 0x07, 0x00, 0x07, 0x00,// 02
;0x14, 0x7F, 0x14, 0x7F, 0x14,// 03
;0x24, 0x2A, 0x7F, 0x2A, 0x12,// 04
;0x23, 0x13, 0x08, 0x64, 0x62,// 05
;0x36, 0x49, 0x55, 0x22, 0x50,// 06
;0x00, 0x05, 0x03, 0x00, 0x00,// 07
;0x00, 0x1C, 0x22, 0x41, 0x00,// 08
;0x00, 0x41, 0x22, 0x1C, 0x00,// 09
;0x14, 0x08, 0x3E, 0x08, 0x14,// 0A
;0x08, 0x08, 0x3E, 0x08, 0x08,// 0B
;0x00, 0x50, 0x30, 0x00, 0x00,// 0C
;0x08, 0x08, 0x08, 0x08, 0x08,// 0D
;0x00, 0x60, 0x60, 0x00, 0x00,// 0E
;0x20, 0x10, 0x08, 0x04, 0x02,// 0F
;0x00, 0x00, 0x00, 0x00, 0x00,// 10
;0x00, 0x00, 0x5F, 0x00, 0x00,// 11
;0x00, 0x07, 0x00, 0x07, 0x00,// 12
;0x14, 0x7F, 0x14, 0x7F, 0x14,// 13
;0x24, 0x2A, 0x7F, 0x2A, 0x12,// 14
;0x23, 0x13, 0x08, 0x64, 0x62,// 15
;0x36, 0x49, 0x55, 0x22, 0x50,// 16
;0x00, 0x05, 0x03, 0x00, 0x00,// 17
;0x00, 0x1C, 0x22, 0x41, 0x00,// 18
;0x00, 0x41, 0x22, 0x1C, 0x00,// 19
;0x14, 0x08, 0x3E, 0x08, 0x14,// 1A
;0x08, 0x08, 0x3E, 0x08, 0x08,// 1B
;0x00, 0x50, 0x30, 0x00, 0x00,// 1C
;0x08, 0x08, 0x08, 0x08, 0x08,// 1D
;0x00, 0x60, 0x60, 0x00, 0x00,// 1E
;0x20, 0x10, 0x08, 0x04, 0x02,// 1F
;0x00, 0x00, 0x00, 0x00, 0x00,// 20 space
;0x00, 0x00, 0x5F, 0x00, 0x00,// 21 !
;0x00, 0x07, 0x00, 0x07, 0x00,// 22 "
;0x14, 0x7F, 0x14, 0x7F, 0x14,// 23 #
;0x24, 0x2A, 0x7F, 0x2A, 0x12,// 24 $
;0x23, 0x13, 0x08, 0x64, 0x62,// 25 %
;0x36, 0x49, 0x55, 0x22, 0x50,// 26 &
;0x00, 0x05, 0x03, 0x00, 0x00,// 27 '
;0x00, 0x1C, 0x22, 0x41, 0x00,// 28 (
;0x00, 0x41, 0x22, 0x1C, 0x00,// 29 )
;0x14, 0x08, 0x3E, 0x08, 0x14,// 2a *
;0x08, 0x08, 0x3E, 0x08, 0x08,// 2b +
;0x00, 0x50, 0x30, 0x00, 0x00,// 2c ,
;0x08, 0x08, 0x08, 0x08, 0x08,// 2d -
;0x00, 0x60, 0x60, 0x00, 0x00,// 2e .
;0x20, 0x10, 0x08, 0x04, 0x02,// 2f /
;0x3E, 0x51, 0x49, 0x45, 0x3E,// 30 0
;0x00, 0x42, 0x7F, 0x40, 0x00,// 31 1
;0x42, 0x61, 0x51, 0x49, 0x46,// 32 2
;0x21, 0x41, 0x45, 0x4B, 0x31,// 33 3
;0x18, 0x14, 0x12, 0x7F, 0x10,// 34 4
;0x27, 0x45, 0x45, 0x45, 0x39,// 35 5
;0x3C, 0x4A, 0x49, 0x49, 0x30,// 36 6
;0x01, 0x71, 0x09, 0x05, 0x03,// 37 7
;0x36, 0x49, 0x49, 0x49, 0x36,// 38 8
;0x06, 0x49, 0x49, 0x29, 0x1E,// 39 9
;0x00, 0x36, 0x36, 0x00, 0x00,// 3a :
;0x00, 0x56, 0x36, 0x00, 0x00,// 3b ;
;0x08, 0x14, 0x22, 0x41, 0x00,// 3c <
;0x14, 0x14, 0x14, 0x14, 0x14,// 3d =
;0x00, 0x41, 0x22, 0x14, 0x08,// 3e >
;0x02, 0x01, 0x51, 0x09, 0x06,// 3f ?
;0x32, 0x49, 0x79, 0x41, 0x3E,// 40 @
;0x7E, 0x11, 0x11, 0x11, 0x7E,// 41 A
;0x7F, 0x49, 0x49, 0x49, 0x36,// 42 B
;0x3E, 0x41, 0x41, 0x41, 0x22,// 43 C
;0x7F, 0x41, 0x41, 0x22, 0x1C,// 44 D
;0x7F, 0x49, 0x49, 0x49, 0x41,// 45 E
;0x7F, 0x09, 0x09, 0x09, 0x01,// 46 F
;0x3E, 0x41, 0x49, 0x49, 0x7A,// 47 G
;0x7F, 0x08, 0x08, 0x08, 0x7F,// 48 H
;0x00, 0x41, 0x7F, 0x41, 0x00,// 49 I
;0x20, 0x40, 0x41, 0x3F, 0x01,// 4a J
;0x7F, 0x08, 0x14, 0x22, 0x41,// 4b K
;0x7F, 0x40, 0x40, 0x40, 0x40,// 4c L
;0x7F, 0x02, 0x0C, 0x02, 0x7F,// 4d M
;0x7F, 0x04, 0x08, 0x10, 0x7F,// 4e N
;0x3E, 0x41, 0x41, 0x41, 0x3E,// 4f O
;0x7F, 0x09, 0x09, 0x09, 0x06,// 50 P
;0x3E, 0x41, 0x51, 0x21, 0x5E,// 51 Q
;0x7F, 0x09, 0x19, 0x29, 0x46,// 52 R
;0x46, 0x49, 0x49, 0x49, 0x31,// 53 S
;0x01, 0x01, 0x7F, 0x01, 0x01,// 54 T
;0x3F, 0x40, 0x40, 0x40, 0x3F,// 55 U
;0x1F, 0x20, 0x40, 0x20, 0x1F,// 56 V
;0x3F, 0x40, 0x38, 0x40, 0x3F,// 57 W
;0x63, 0x14, 0x08, 0x14, 0x63,// 58 X
;0x07, 0x08, 0x70, 0x08, 0x07,// 59 Y
;0x61, 0x51, 0x49, 0x45, 0x43,// 5a Z
;0x00, 0x7F, 0x41, 0x41, 0x00,// 5b [
;0x02, 0x04, 0x08, 0x10, 0x20,// 5c Yen Currency Sign
;0x00, 0x41, 0x41, 0x7F, 0x00,// 5d ]
;0x04, 0x02, 0x01, 0x02, 0x04,// 5e ^
;0x40, 0x40, 0x40, 0x40, 0x40,// 5f _
;0x00, 0x06, 0x09, 0x09, 0x06,// 60 `  //  `
;0x20, 0x54, 0x54, 0x54, 0x78,// 61 a
;0x7F, 0x48, 0x44, 0x44, 0x38,// 62 b
;0x38, 0x44, 0x44, 0x44, 0x20,// 63 c
;0x38, 0x44, 0x44, 0x48, 0x7F,// 64 d
;0x38, 0x54, 0x54, 0x54, 0x18,// 65 e
;0x08, 0x7E, 0x09, 0x01, 0x02,// 66 f
;0x0C, 0x52, 0x52, 0x52, 0x3E,// 67 g
;0x7F, 0x08, 0x04, 0x04, 0x78,// 68 h
;0x00, 0x44, 0x7D, 0x40, 0x00,// 69 i
;0x20, 0x40, 0x44, 0x3D, 0x00,// 6a j
;0x7F, 0x10, 0x28, 0x44, 0x00,// 6b k
;0x00, 0x41, 0x7F, 0x40, 0x00,// 6c l
;0x7C, 0x04, 0x18, 0x04, 0x78,// 6d m
;0x7C, 0x08, 0x04, 0x04, 0x78,// 6e n
;0x38, 0x44, 0x44, 0x44, 0x38,// 6f o
;0x7C, 0x14, 0x14, 0x14, 0x08,// 70 p
;0x08, 0x14, 0x14, 0x18, 0x7C,// 71 q
;0x7C, 0x08, 0x04, 0x04, 0x08,// 72 r
;0x08, 0x54, 0x54, 0x54, 0x20,// 73 s
;0x04, 0x3F, 0x44, 0x40, 0x20,// 74 t
;0x3C, 0x40, 0x40, 0x20, 0x7C,// 75 u
;0x1C, 0x20, 0x40, 0x20, 0x1C,// 76 v
;0x3C, 0x40, 0x30, 0x40, 0x3C,// 77 w
;0x44, 0x28, 0x10, 0x28, 0x44,// 78 x
;0x0C, 0x50, 0x50, 0x50, 0x3C,// 79 y
;0x44, 0x64, 0x54, 0x4C, 0x44,// 7a z
;0x00, 0x08, 0x36, 0x41, 0x00,// 7b <
;0x00, 0x00, 0x7F, 0x00, 0x00,// 7c |
;0x00, 0x41, 0x36, 0x08, 0x00,// 7d >
;0x10, 0x08, 0x08, 0x10, 0x08,// 7e Right Arrow ->
;0x78, 0x46, 0x41, 0x46, 0x78,// 7f Left Arrow <-
;0x00, 0x00, 0x00, 0x00, 0x00,// 80
;0x00, 0x00, 0x5F, 0x00, 0x00,// 81
;0x00, 0x07, 0x00, 0x07, 0x00,// 82
;0x14, 0x7F, 0x14, 0x7F, 0x14,// 83
;0x24, 0x2A, 0x7F, 0x2A, 0x12,// 84
;0x23, 0x13, 0x08, 0x64, 0x62,// 85
;0x36, 0x49, 0x55, 0x22, 0x50,// 86
;0x00, 0x05, 0x03, 0x00, 0x00,// 87
;0x00, 0x1C, 0x22, 0x41, 0x00,// 88
;0x00, 0x41, 0x22, 0x1C, 0x00,// 89
;0x14, 0x08, 0x3E, 0x08, 0x14,// 8A
;0x08, 0x08, 0x3E, 0x08, 0x08,// 8B
;0x00, 0x50, 0x30, 0x00, 0x00,// 8C
;0x08, 0x08, 0x08, 0x08, 0x08,// 8D
;0x00, 0x60, 0x60, 0x00, 0x00,// 8E
;0x20, 0x10, 0x08, 0x04, 0x02,// 8F
;0x00, 0x00, 0x00, 0x00, 0x00,// 90
;0x00, 0x00, 0x5F, 0x00, 0x00,// 91
;0x00, 0x07, 0x00, 0x07, 0x00,// 92
;0x14, 0x7F, 0x14, 0x7F, 0x14,// 93
;0x24, 0x2A, 0x7F, 0x2A, 0x12,// 94
;0x23, 0x13, 0x08, 0x64, 0x62,// 95
;0x36, 0x49, 0x55, 0x22, 0x50,// 96
;0x00, 0x05, 0x03, 0x00, 0x00,// 97
;0x00, 0x1C, 0x22, 0x41, 0x00,// 98
;0x00, 0x41, 0x22, 0x1C, 0x00,// 99
;0x14, 0x08, 0x3E, 0x08, 0x14,// 9A
;0x08, 0x08, 0x3E, 0x08, 0x08,// 9B
;0x00, 0x50, 0x30, 0x00, 0x00,// 9C
;0x08, 0x08, 0x08, 0x08, 0x08,// 9D
;0x00, 0x60, 0x60, 0x00, 0x00,// 9E
;0x20, 0x10, 0x08, 0x04, 0x02,// 9F
;0x00, 0x00, 0x00, 0x00, 0x00,// A0
;0x00, 0x00, 0x5F, 0x00, 0x00,// A1
;0x00, 0x07, 0x00, 0x07, 0x00,// A2
;0x14, 0x7F, 0x14, 0x7F, 0x14,// A3
;0x24, 0x2A, 0x7F, 0x2A, 0x12,// A4
;0x23, 0x13, 0x08, 0x64, 0x62,// A5
;0x36, 0x49, 0x55, 0x22, 0x50,// A6
;0x00, 0x05, 0x03, 0x00, 0x00,// A7
;0x00, 0x1C, 0x22, 0x41, 0x00,// A8
;0x00, 0x41, 0x22, 0x1C, 0x00,// A9
;0x14, 0x08, 0x3E, 0x08, 0x14,// AA
;0x08, 0x08, 0x3E, 0x08, 0x08,// AB
;0x00, 0x50, 0x30, 0x00, 0x00,// AC
;0x08, 0x08, 0x08, 0x08, 0x08,// AD
;0x00, 0x60, 0x60, 0x00, 0x00,// AE
;0x20, 0x10, 0x08, 0x04, 0x02,// AF
;//0x3E, 0x51, 0x49, 0x45, 0x3E,// B0
;0x00, 0x06, 0x09, 0x09, 0x06,  //  
;0x00, 0x42, 0x7F, 0x40, 0x00,// B1
;0x42, 0x61, 0x51, 0x49, 0x46,// B2
;0x21, 0x41, 0x45, 0x4B, 0x31,// B3
;0x18, 0x14, 0x12, 0x7F, 0x10,// B4
;0x27, 0x45, 0x45, 0x45, 0x39,// B5
;0x3C, 0x4A, 0x49, 0x49, 0x30,// B6
;0x01, 0x71, 0x09, 0x05, 0x03,// B7
;0x36, 0x49, 0x49, 0x49, 0x36,// B8
;0x06, 0x49, 0x49, 0x29, 0x1E,// B9
;0x00, 0x36, 0x36, 0x00, 0x00,// BA
;0x00, 0x56, 0x36, 0x00, 0x00,// BB
;0x08, 0x14, 0x22, 0x41, 0x00,// BC
;0x14, 0x14, 0x14, 0x14, 0x14,// BD
;0x00, 0x41, 0x22, 0x14, 0x08,// BE
;0x02, 0x01, 0x51, 0x09, 0x06,// BF
;0x7E, 0x11, 0x11, 0x11, 0x7E,// C0 
;0x7F, 0x49, 0x49, 0x49, 0x31,// C1 
;0x7F, 0x49, 0x49, 0x49, 0x36,// C2 
;0x7F, 0x01, 0x01, 0x01, 0x03,// C3 
;0x60, 0x3E, 0x21, 0x21, 0x7F,// C4 
;0x7F, 0x49, 0x49, 0x49, 0x41,// C5 
;0x77, 0x08, 0x7F, 0x08, 0x77,// C6 
;0x22, 0x41, 0x49, 0x49, 0x36,// C7 
;0x7F, 0x10, 0x08, 0x04, 0x7F,// C8 
;0x7F, 0x10, 0x09, 0x04, 0x7F,// C9 
;0x7F, 0x08, 0x14, 0x22, 0x41,// CA 
;0x40, 0x3E, 0x01, 0x01, 0x7F,// CB 
;0x7F, 0x02, 0x0C, 0x02, 0x7F,// CC 
;0x7F, 0x08, 0x08, 0x08, 0x7F,// CD 
;0x3E, 0x41, 0x41, 0x41, 0x3E,// CE 
;0x7F, 0x01, 0x01, 0x01, 0x7F,// CF 
;0x7F, 0x09, 0x09, 0x09, 0x06,// D0 
;0x3E, 0x41, 0x41, 0x41, 0x22,// D1 
;0x01, 0x01, 0x7F, 0x01, 0x01,// D2 
;0x27, 0x48, 0x48, 0x48, 0x3F,// D3 
;0x1E, 0x21, 0x7F, 0x21, 0x1E,// D4 
;0x63, 0x14, 0x08, 0x14, 0x63,// D5 
;0x3F, 0x20, 0x20, 0x3F, 0x60,// D6 
;0x07, 0x08, 0x08, 0x08, 0x7F,// D7 
;0x7F, 0x40, 0x7F, 0x40, 0x7F,// D8 
;0x3F, 0x20, 0x3F, 0x20, 0x7F,// D9 
;0x01, 0x7F, 0x48, 0x48, 0x30,// DA 
;0x7F, 0x48, 0x30, 0x00, 0x7F,// DB 
;0x00, 0x7F, 0x48, 0x48, 0x30,// DC 
;0x22, 0x41, 0x49, 0x49, 0x3E,// DD 
;0x7F, 0x08, 0x3E, 0x41, 0x3E,// DE 
;0x46, 0x29, 0x19, 0x09, 0x7F,// DF 
;0x20, 0x54, 0x54, 0x54, 0x78,// E0 
;0x3C, 0x4A, 0x4A, 0x4A, 0x30,// E1 
;0x7C, 0x54, 0x54, 0x28, 0x00,// E2 
;0x7C, 0x04, 0x04, 0x04, 0x04,// E3 
;0x60, 0x38, 0x24, 0x24, 0x7C,// E4 
;0x38, 0x54, 0x54, 0x54, 0x18,// E5 
;0x6C, 0x10, 0x7C, 0x10, 0x6C,// E6 
;0x00, 0x44, 0x54, 0x54, 0x28,// E7 
;0x7C, 0x20, 0x10, 0x08, 0x7C,// E8 
;0x7C, 0x21, 0x12, 0x09, 0x7C,// E9 
;0x7C, 0x10, 0x28, 0x44, 0x00,// EA 
;0x40, 0x38, 0x04, 0x04, 0x7C,// EB 
;0x7C, 0x08, 0x10, 0x08, 0x7C,// EC 
;0x7C, 0x10, 0x10, 0x10, 0x7C,// ED 
;0x38, 0x44, 0x44, 0x44, 0x38,// EE 
;0x7C, 0x04, 0x04, 0x04, 0x7C,// EF 
;0x7C, 0x14, 0x14, 0x14, 0x08,// F0 
;0x38, 0x44, 0x44, 0x44, 0x00,// F1 
;0x04, 0x04, 0x7C, 0x04, 0x04,// F2 
;0x0C, 0x50, 0x50, 0x50, 0x3C,// F3 
;0x08, 0x14, 0x7C, 0x14, 0x08,// F4 
;0x44, 0x28, 0x10, 0x28, 0x44,// F5 
;0x3C, 0x20, 0x20, 0x3C, 0x60,// F6 
;0x0C, 0x10, 0x10, 0x10, 0x7C,// F7 
;0x7C, 0x40, 0x7C, 0x40, 0x7C,// F8 
;0x3C, 0x20, 0x3C, 0x20, 0x7C,// F9 
;0x04, 0x7C, 0x50, 0x50, 0x20,// FA 
;0x7C, 0x50, 0x20, 0x00, 0x7C,// FB 
;0x00, 0x7C, 0x50, 0x50, 0x20,// FC 
;0x28, 0x44, 0x54, 0x54, 0x38,// FD 
;0x7C, 0x10, 0x38, 0x44, 0x38,// FE 
;0x48, 0x54, 0x34, 0x14, 0x7C // FF 
;};
;
;unsigned char dig_number; //  
;unsigned char dig,simvol,d;  //  . -;simvol - ;d -   
;unsigned char data[]; //   
;unsigned char stolb=48;  //  - 
;unsigned char s_stolb=5;  //  -  (  )
;unsigned char s_char=10;   //    
;unsigned char n_simvol;   //    
;unsigned char space;   //
;unsigned char input_us[52];  //     
;unsigned char input_mem[52];  //     
;unsigned char out,out1,out2,out3,out4,out5,out6,out7,out8,out9;//    
;unsigned char menu=0; //   
;unsigned int i=1; //  

	.DSEG
;unsigned long int t=0; // 
;
;void show_dig()
; 0000 0138  {

	.CSEG
_show_dig:
; 0000 0139   if(simvol==0)PORTA=~led_tab[out][dig];    //    
	TST  R7
	BRNE _0x4
	MOV  R30,R12
	RCALL SUBOPT_0x0
; 0000 013A   if(simvol==1)PORTA=~led_tab[out1][dig];    //    
_0x4:
	LDI  R30,LOW(1)
	CP   R30,R7
	BRNE _0x5
	LDS  R30,_out1
	RCALL SUBOPT_0x0
; 0000 013B   if(simvol==2)PORTA=~led_tab[out2][dig];    //    
_0x5:
	LDI  R30,LOW(2)
	CP   R30,R7
	BRNE _0x6
	LDS  R30,_out2
	RCALL SUBOPT_0x0
; 0000 013C   if(simvol==3)PORTA=~led_tab[out3][dig];    //    
_0x6:
	LDI  R30,LOW(3)
	CP   R30,R7
	BRNE _0x7
	LDS  R30,_out3
	RCALL SUBOPT_0x0
; 0000 013D   if(simvol==4)PORTA=~led_tab[out4][dig];    //    
_0x7:
	LDI  R30,LOW(4)
	CP   R30,R7
	BRNE _0x8
	LDS  R30,_out4
	RCALL SUBOPT_0x0
; 0000 013E   if(simvol==5)PORTA=~led_tab[out5][dig];    //    
_0x8:
	LDI  R30,LOW(5)
	CP   R30,R7
	BRNE _0x9
	LDS  R30,_out5
	RCALL SUBOPT_0x0
; 0000 013F   if(simvol==6)PORTA=~led_tab[out6][dig];    //    
_0x9:
	LDI  R30,LOW(6)
	CP   R30,R7
	BRNE _0xA
	LDS  R30,_out6
	RCALL SUBOPT_0x0
; 0000 0140   if(simvol==7)PORTA=~led_tab[out7][dig];    //    
_0xA:
	LDI  R30,LOW(7)
	CP   R30,R7
	BRNE _0xB
	LDS  R30,_out7
	RCALL SUBOPT_0x0
; 0000 0141   if(simvol==8)PORTA=~led_tab[out8][dig];    //    
_0xB:
	LDI  R30,LOW(8)
	CP   R30,R7
	BRNE _0xC
	LDS  R30,_out8
	RCALL SUBOPT_0x0
; 0000 0142   if(simvol==9)PORTA=~led_tab[out9][dig];    //    
_0xC:
	LDI  R30,LOW(9)
	CP   R30,R7
	BRNE _0xD
	LDS  R30,_out9
	RCALL SUBOPT_0x0
; 0000 0143   ST=0;                  //""  
_0xD:
	CBI  0x18,0
; 0000 0144    data[0]=1<<dig_number; //     1   " 0"
	MOV  R30,R5
	LDI  R26,LOW(1)
	RCALL __LSLB12
	STS  _data,R30
; 0000 0145      DS=data[0]&1;       // ""
	ANDI R30,LOW(0x1)
	BRNE _0x10
	CBI  0x18,1
	RJMP _0x11
_0x10:
	SBI  0x18,1
_0x11:
; 0000 0146      SH=1;               //    +
	SBI  0x18,2
; 0000 0147      SH=0;               //   -
	CBI  0x18,2
; 0000 0148      data[0]>>=1;         //     1
	LDS  R30,_data
	RCALL SUBOPT_0x1
	ASR  R31
	ROR  R30
	STS  _data,R30
; 0000 0149     if (dig_number==0) {dig_number=stolb;dig=s_stolb;simvol=0;}  //    
	TST  R5
	BRNE _0x16
	MOV  R5,R9
	MOV  R4,R8
	CLR  R7
; 0000 014A    dig_number--;            //    
_0x16:
	DEC  R5
; 0000 014B      if (dig ==0 ){dig = s_stolb;simvol++;}  //  -     
	TST  R4
	BRNE _0x17
	MOV  R4,R8
	INC  R7
; 0000 014C       dig--;                    //    
_0x17:
	DEC  R4
; 0000 014D        ST=1;               //     
	SBI  0x18,0
; 0000 014E      if(simvol>s_char) simvol=0;   // 
	CP   R11,R7
	BRSH _0x1A
	CLR  R7
; 0000 014F   }
_0x1A:
	RET
;
;void us()
; 0000 0152  {
_us:
; 0000 0153     while(UCSRA.7)     //    -   
_0x1B:
	SBIS 0xB,7
	RJMP _0x1D
; 0000 0154        {
; 0000 0155 
; 0000 0156         input_us[d]=UDR;     //   
	RCALL SUBOPT_0x2
	SUBI R26,LOW(-_input_us)
	SBCI R27,HIGH(-_input_us)
	IN   R30,0xC
	ST   X,R30
; 0000 0157         if(input_us[d]!=input_mem[d]){input_mem[d]=input_us[d];} //     
	MOV  R30,R6
	RCALL SUBOPT_0x1
	MOVW R0,R30
	SUBI R30,LOW(-_input_us)
	SBCI R31,HIGH(-_input_us)
	LD   R26,Z
	MOVW R30,R0
	SUBI R30,LOW(-_input_mem)
	SBCI R31,HIGH(-_input_mem)
	LD   R30,Z
	CP   R30,R26
	BREQ _0x1E
	RCALL SUBOPT_0x2
	SUBI R26,LOW(-_input_mem)
	SBCI R27,HIGH(-_input_mem)
	RCALL SUBOPT_0x3
	LD   R30,Z
	ST   X,R30
; 0000 0158         if(input_us[d]==46)                                      //  
_0x1E:
	RCALL SUBOPT_0x3
	LD   R26,Z
	CPI  R26,LOW(0x2E)
	BRNE _0x1F
; 0000 0159          {
; 0000 015A          if(d>=12){n_simvol=d+1;}//   
	LDI  R30,LOW(12)
	CP   R6,R30
	BRLO _0x20
	MOV  R30,R6
	SUBI R30,-LOW(1)
	MOV  R10,R30
; 0000 015B          else{n_simvol=d;}//   
	RJMP _0x21
_0x20:
	MOV  R10,R6
_0x21:
; 0000 015C           LED=1;
	SBI  0x12,7
; 0000 015D           d=50;//    - . ()
	LDI  R30,LOW(50)
	MOV  R6,R30
; 0000 015E          }
; 0000 015F          else
	RJMP _0x24
_0x1F:
; 0000 0160          {
; 0000 0161          LED=0;
	CBI  0x12,7
; 0000 0162          }
_0x24:
; 0000 0163          if(input_us[0]==207&&input_us[1]==208&&input_us[2]==206
; 0000 0164          &&input_us[3]==194&&input_us[4]==197&&input_us[5]==208
; 0000 0165          &&input_us[6]==202&&input_us[7]==192)  // ( )
	LDS  R26,_input_us
	CPI  R26,LOW(0xCF)
	BRNE _0x28
	__GETB2MN _input_us,1
	CPI  R26,LOW(0xD0)
	BRNE _0x28
	__GETB2MN _input_us,2
	CPI  R26,LOW(0xCE)
	BRNE _0x28
	__GETB2MN _input_us,3
	CPI  R26,LOW(0xC2)
	BRNE _0x28
	__GETB2MN _input_us,4
	CPI  R26,LOW(0xC5)
	BRNE _0x28
	__GETB2MN _input_us,5
	CPI  R26,LOW(0xD0)
	BRNE _0x28
	__GETB2MN _input_us,6
	CPI  R26,LOW(0xCA)
	BRNE _0x28
	__GETB2MN _input_us,7
	CPI  R26,LOW(0xC0)
	BREQ _0x29
_0x28:
	RJMP _0x27
_0x29:
; 0000 0166          {menu=1;}
	LDI  R30,LOW(1)
	RCALL SUBOPT_0x4
; 0000 0167         d++;
_0x27:
	INC  R6
; 0000 0168        }
	RJMP _0x1B
_0x1D:
; 0000 0169 
; 0000 016A     if(d>=51)
	LDI  R30,LOW(51)
	CP   R6,R30
	BRLO _0x2A
; 0000 016B     {
; 0000 016C      /*
; 0000 016D      switch(n_simvol)
; 0000 016E      {
; 0000 016F      case (0):
; 0000 0170                     //   
; 0000 0171 
; 0000 0172      break;          // .....
; 0000 0173      case (1):
; 0000 0174                     //  
; 0000 0175          input_mem[1]=0;
; 0000 0176          input_mem[2]=0;
; 0000 0177          input_mem[3]=0;
; 0000 0178          input_mem[4]=0;
; 0000 0179          input_mem[5]=0;
; 0000 017A          input_mem[6]=0;
; 0000 017B          input_mem[7]=0;
; 0000 017C          input_mem[8]=0;
; 0000 017D          input_mem[9]=0;
; 0000 017E          input_mem[10]=0;
; 0000 017F          input_mem[11]=0;
; 0000 0180          input_mem[12]=0;
; 0000 0181      break;          // .....
; 0000 0182      case (2):
; 0000 0183                    //  
; 0000 0184          input_mem[2]=0;
; 0000 0185          input_mem[3]=0;
; 0000 0186          input_mem[4]=0;
; 0000 0187          input_mem[5]=0;
; 0000 0188          input_mem[6]=0;
; 0000 0189          input_mem[7]=0;
; 0000 018A          input_mem[8]=0;
; 0000 018B          input_mem[9]=0;
; 0000 018C          input_mem[10]=0;
; 0000 018D          input_mem[11]=0;
; 0000 018E          input_mem[12]=0;
; 0000 018F      break;          // .....
; 0000 0190      case (3):
; 0000 0191                    //  
; 0000 0192          input_mem[3]=0;
; 0000 0193          input_mem[4]=0;
; 0000 0194          input_mem[5]=0;
; 0000 0195          input_mem[6]=0;
; 0000 0196          input_mem[7]=0;
; 0000 0197          input_mem[8]=0;
; 0000 0198          input_mem[9]=0;
; 0000 0199          input_mem[10]=0;
; 0000 019A          input_mem[11]=0;
; 0000 019B          input_mem[12]=0;
; 0000 019C      break;          // .....
; 0000 019D      case (4):
; 0000 019E                     //  
; 0000 019F          input_mem[4]=0;
; 0000 01A0          input_mem[5]=0;
; 0000 01A1          input_mem[6]=0;
; 0000 01A2          input_mem[7]=0;
; 0000 01A3          input_mem[8]=0;
; 0000 01A4          input_mem[9]=0;
; 0000 01A5          input_mem[10]=0;
; 0000 01A6          input_mem[11]=0;
; 0000 01A7          input_mem[12]=0;
; 0000 01A8      break;          // .....
; 0000 01A9      case (5):
; 0000 01AA                    //  
; 0000 01AB          input_mem[5]=0;
; 0000 01AC          input_mem[6]=0;
; 0000 01AD          input_mem[7]=0;
; 0000 01AE          input_mem[8]=0;
; 0000 01AF          input_mem[9]=0;
; 0000 01B0          input_mem[10]=0;
; 0000 01B1          input_mem[11]=0;
; 0000 01B2          input_mem[12]=0;
; 0000 01B3      break;          // .....
; 0000 01B4      case (6):
; 0000 01B5                    //  
; 0000 01B6          input_mem[6]=0;
; 0000 01B7          input_mem[7]=0;
; 0000 01B8          input_mem[8]=0;
; 0000 01B9          input_mem[9]=0;
; 0000 01BA          input_mem[10]=0;
; 0000 01BB          input_mem[11]=0;
; 0000 01BC          input_mem[12]=0;
; 0000 01BD      break;          // .....
; 0000 01BE      case (7):
; 0000 01BF                    //  
; 0000 01C0          input_mem[7]=0;
; 0000 01C1          input_mem[8]=0;
; 0000 01C2          input_mem[9]=0;
; 0000 01C3          input_mem[10]=0;
; 0000 01C4          input_mem[11]=0;
; 0000 01C5          input_mem[12]=0;
; 0000 01C6      break;          // .....
; 0000 01C7      case (8):
; 0000 01C8                     //  
; 0000 01C9          input_mem[8]=0;
; 0000 01CA          input_mem[9]=0;
; 0000 01CB          input_mem[10]=0;
; 0000 01CC          input_mem[11]=0;
; 0000 01CD          input_mem[12]=0;
; 0000 01CE      break;          // .....
; 0000 01CF      case (9):
; 0000 01D0                     //  
; 0000 01D1          input_mem[9]=0;
; 0000 01D2          input_mem[10]=0;
; 0000 01D3          input_mem[11]=0;
; 0000 01D4          input_mem[12]=0;
; 0000 01D5      break;          // .....
; 0000 01D6      case (10):
; 0000 01D7                     //  d
; 0000 01D8          input_mem[10]=0;
; 0000 01D9          input_mem[11]=0;
; 0000 01DA          input_mem[12]=0;
; 0000 01DB      break;          // .....
; 0000 01DC      case (11):
; 0000 01DD                     //  
; 0000 01DE          input_mem[11]=0;
; 0000 01DF          input_mem[12]=0;
; 0000 01E0      break;          // .....
; 0000 01E1           case (12):
; 0000 01E2                     //  
; 0000 01E3          input_mem[12]=0;
; 0000 01E4      break;          // .....
; 0000 01E5      }
; 0000 01E6       */
; 0000 01E7 
; 0000 01E8       for(space=n_simvol; space<=51;space++) //   
	MOV  R13,R10
_0x2C:
	LDI  R30,LOW(51)
	CP   R30,R13
	BRLO _0x2D
; 0000 01E9       {                                      //   
; 0000 01EA         input_mem[space]=0;// claener memory
	MOV  R30,R13
	RCALL SUBOPT_0x1
	SUBI R30,LOW(-_input_mem)
	SBCI R31,HIGH(-_input_mem)
	LDI  R26,LOW(0)
	STD  Z+0,R26
; 0000 01EB       }
	INC  R13
	RJMP _0x2C
_0x2D:
; 0000 01EC       if(space>=51) //   
	LDI  R30,LOW(51)
	CP   R13,R30
	BRLO _0x2E
; 0000 01ED       {
; 0000 01EE         out=input_mem[9];
	__GETBRMN 12,_input_mem,9
; 0000 01EF        out1=input_mem[8];
	__GETB1MN _input_mem,8
	RCALL SUBOPT_0x5
; 0000 01F0        out2=input_mem[7];
	__GETB1MN _input_mem,7
	RCALL SUBOPT_0x6
; 0000 01F1        out3=input_mem[6];
	__GETB1MN _input_mem,6
	RCALL SUBOPT_0x7
; 0000 01F2        out4=input_mem[5];
	__GETB1MN _input_mem,5
	RCALL SUBOPT_0x8
; 0000 01F3        out5=input_mem[4];
	__GETB1MN _input_mem,4
	RCALL SUBOPT_0x9
; 0000 01F4        out6=input_mem[3];
	__GETB1MN _input_mem,3
	RCALL SUBOPT_0xA
; 0000 01F5        out7=input_mem[2];
	__GETB1MN _input_mem,2
	RCALL SUBOPT_0xB
; 0000 01F6        out8=input_mem[1];
	__GETB1MN _input_mem,1
	RCALL SUBOPT_0xC
; 0000 01F7        out9=input_mem[0];
	LDS  R30,_input_mem
	RCALL SUBOPT_0xD
; 0000 01F8 
; 0000 01F9          d=0;
	CLR  R6
; 0000 01FA        }
; 0000 01FB         }
_0x2E:
; 0000 01FC  }
_0x2A:
	RET
;
; void btn()
; 0000 01FF  {
_btn:
; 0000 0200   if(btn_m==0)
	SBIC 0x13,7
	RJMP _0x2F
; 0000 0201   {
; 0000 0202   delay_ms(100);
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _delay_ms
; 0000 0203   out=out1=out2=out3=out4=out5=out6=out7=out8=out9=0; // x
	RCALL SUBOPT_0xE
; 0000 0204   menu++;
	LDS  R30,_menu
	SUBI R30,-LOW(1)
	RCALL SUBOPT_0x4
; 0000 0205   }
; 0000 0206    if(menu>=2)
_0x2F:
	LDS  R26,_menu
	CPI  R26,LOW(0x2)
	BRLO _0x30
; 0000 0207     {
; 0000 0208     out=out1=out2=out3=out4=out5=out6=out7=out8=out9=0; // x
	RCALL SUBOPT_0xE
; 0000 0209      menu=0;
	LDI  R30,LOW(0)
	RCALL SUBOPT_0x4
; 0000 020A      }
; 0000 020B 
; 0000 020C     if(menu==1)
_0x30:
	LDS  R26,_menu
	CPI  R26,LOW(0x1)
	BREQ PC+2
	RJMP _0x31
; 0000 020D     {
; 0000 020E        t++;
	LDI  R26,LOW(_t)
	LDI  R27,HIGH(_t)
	RCALL __GETD1P_INC
	__SUBD1N -1
	RCALL __PUTDP1_DEC
; 0000 020F        if(t<=700)
	RCALL SUBOPT_0xF
	__CPD2N 0x2BD
	BRSH _0x32
; 0000 0210        {
; 0000 0211          out9=32;
	LDI  R30,LOW(32)
	RCALL SUBOPT_0xD
; 0000 0212          out8=207; // 
	LDI  R30,LOW(207)
	RCALL SUBOPT_0xC
; 0000 0213          out7=208; // 
	LDI  R30,LOW(208)
	RCALL SUBOPT_0xB
; 0000 0214          out6=206; // 
	LDI  R30,LOW(206)
	RCALL SUBOPT_0xA
; 0000 0215          out5=194; // 
	LDI  R30,LOW(194)
	RCALL SUBOPT_0x9
; 0000 0216          out4=197; // 
	LDI  R30,LOW(197)
	RCALL SUBOPT_0x8
; 0000 0217          out3=208; // 
	LDI  R30,LOW(208)
	RCALL SUBOPT_0x7
; 0000 0218          out2=202; // 
	LDI  R30,LOW(202)
	RCALL SUBOPT_0x6
; 0000 0219          out1=192; // 
	LDI  R30,LOW(192)
	RCALL SUBOPT_0x5
; 0000 021A          out=32;  //
	LDI  R30,LOW(32)
	MOV  R12,R30
; 0000 021B         }
; 0000 021C        if(t>=700&&i!=0)
_0x32:
	RCALL SUBOPT_0xF
	__CPD2N 0x2BC
	BRLO _0x34
	RCALL SUBOPT_0x10
	SBIW R26,0
	BRNE _0x35
_0x34:
	RJMP _0x33
_0x35:
; 0000 021D        {
; 0000 021E        out=input_us[9];
	__GETBRMN 12,_input_us,9
; 0000 021F        out1=input_us[8];
	__GETB1MN _input_us,8
	RCALL SUBOPT_0x5
; 0000 0220        out2=input_us[7];
	__GETB1MN _input_us,7
	RCALL SUBOPT_0x6
; 0000 0221        out3=input_us[6];
	__GETB1MN _input_us,6
	RCALL SUBOPT_0x7
; 0000 0222        out4=input_us[5];
	__GETB1MN _input_us,5
	RCALL SUBOPT_0x8
; 0000 0223        out5=input_us[4];
	__GETB1MN _input_us,4
	RCALL SUBOPT_0x9
; 0000 0224        out6=input_us[3];
	__GETB1MN _input_us,3
	RCALL SUBOPT_0xA
; 0000 0225        out7=input_us[2];
	__GETB1MN _input_us,2
	RCALL SUBOPT_0xB
; 0000 0226        out8=input_us[1];
	__GETB1MN _input_us,1
	RCALL SUBOPT_0xC
; 0000 0227        out9=input_us[0];
	LDS  R30,_input_us
	RCALL SUBOPT_0xD
; 0000 0228 
; 0000 0229            if(i>=255)
	RCALL SUBOPT_0x10
	CPI  R26,LOW(0xFF)
	LDI  R30,HIGH(0xFF)
	CPC  R27,R30
	BRLO _0x36
; 0000 022A           {i=0;
	LDI  R30,LOW(0)
	STS  _i,R30
	STS  _i+1,R30
; 0000 022B             out9=32;
	LDI  R30,LOW(32)
	RCALL SUBOPT_0xD
; 0000 022C             out8=62; // >
	LDI  R30,LOW(62)
	RCALL SUBOPT_0xC
; 0000 022D             out7=202; // 
	LDI  R30,LOW(202)
	RCALL SUBOPT_0xB
; 0000 022E             out6=206; // 
	LDI  R30,LOW(206)
	RCALL SUBOPT_0xA
; 0000 022F             out5=205; // 
	LDI  R30,LOW(205)
	RCALL SUBOPT_0x9
; 0000 0230             out4=197; // 
	LDI  R30,LOW(197)
	RCALL SUBOPT_0x8
; 0000 0231             out3=214; // 
	LDI  R30,LOW(214)
	RCALL SUBOPT_0x7
; 0000 0232             out2=21; // !
	LDI  R30,LOW(21)
	RCALL SUBOPT_0x6
; 0000 0233             out1=60; //  <
	LDI  R30,LOW(60)
	RCALL SUBOPT_0x5
; 0000 0234             out=32;  //
	LDI  R30,LOW(32)
	MOV  R12,R30
; 0000 0235           }
; 0000 0236 
; 0000 0237         if (i<=256)
_0x36:
	RCALL SUBOPT_0x10
	CPI  R26,LOW(0x101)
	LDI  R30,HIGH(0x101)
	CPC  R27,R30
	BRLO PC+2
	RJMP _0x37
; 0000 0238         {
; 0000 0239         if(simvol==9&&t>=1200)
	LDI  R30,LOW(9)
	CP   R30,R7
	BRNE _0x39
	RCALL SUBOPT_0xF
	__CPD2N 0x4B0
	BRSH _0x3A
_0x39:
	RJMP _0x38
_0x3A:
; 0000 023A          { i++;
	LDI  R26,LOW(_i)
	LDI  R27,HIGH(_i)
	LD   R30,X+
	LD   R31,X+
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
; 0000 023B          input_us[11]=0;
	LDI  R30,LOW(0)
	__PUTB1MN _input_us,11
; 0000 023C          input_us[10]=0;
	__PUTB1MN _input_us,10
; 0000 023D          input_us[9]=0;
	__PUTB1MN _input_us,9
; 0000 023E          input_us[8]=0;
	__PUTB1MN _input_us,8
; 0000 023F          input_us[7]=0;
	__PUTB1MN _input_us,7
; 0000 0240          input_us[6]=0;
	__PUTB1MN _input_us,6
; 0000 0241          input_us[5]=0;
	__PUTB1MN _input_us,5
; 0000 0242          input_us[4]=0;
	__PUTB1MN _input_us,4
; 0000 0243          input_us[3]=0;
	__PUTB1MN _input_us,3
; 0000 0244          input_us[2]=0;
	__PUTB1MN _input_us,2
; 0000 0245          input_us[1]=0;
	__PUTB1MN _input_us,1
; 0000 0246          input_us[0]=0;
	STS  _input_us,R30
; 0000 0247           delay_ms(20);
	LDI  R30,LOW(20)
	LDI  R31,HIGH(20)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _delay_ms
; 0000 0248          input_us[11]=i+11;
	RCALL SUBOPT_0x11
	SUBI R30,-LOW(11)
	__PUTB1MN _input_us,11
; 0000 0249          input_us[10]=i+10;
	RCALL SUBOPT_0x11
	SUBI R30,-LOW(10)
	__PUTB1MN _input_us,10
; 0000 024A          input_us[9]=i+9;
	RCALL SUBOPT_0x11
	SUBI R30,-LOW(9)
	__PUTB1MN _input_us,9
; 0000 024B          input_us[8]=i+8;
	RCALL SUBOPT_0x11
	SUBI R30,-LOW(8)
	__PUTB1MN _input_us,8
; 0000 024C          input_us[7]=i+7;
	RCALL SUBOPT_0x11
	SUBI R30,-LOW(7)
	__PUTB1MN _input_us,7
; 0000 024D          input_us[6]=i+6;
	RCALL SUBOPT_0x11
	SUBI R30,-LOW(6)
	__PUTB1MN _input_us,6
; 0000 024E          input_us[5]=i+5;
	RCALL SUBOPT_0x11
	SUBI R30,-LOW(5)
	__PUTB1MN _input_us,5
; 0000 024F          input_us[4]=i+4;
	RCALL SUBOPT_0x11
	SUBI R30,-LOW(4)
	__PUTB1MN _input_us,4
; 0000 0250          input_us[3]=i+3;
	RCALL SUBOPT_0x11
	SUBI R30,-LOW(3)
	__PUTB1MN _input_us,3
; 0000 0251          input_us[2]=i+2;
	RCALL SUBOPT_0x11
	SUBI R30,-LOW(2)
	__PUTB1MN _input_us,2
; 0000 0252          input_us[1]=i+1;
	RCALL SUBOPT_0x11
	SUBI R30,-LOW(1)
	__PUTB1MN _input_us,1
; 0000 0253          input_us[0]=i;
	RCALL SUBOPT_0x11
	STS  _input_us,R30
; 0000 0254          t=700;
	__GETD1N 0x2BC
	STS  _t,R30
	STS  _t+1,R31
	STS  _t+2,R22
	STS  _t+3,R23
; 0000 0255           }
; 0000 0256         }
_0x38:
; 0000 0257        }
_0x37:
; 0000 0258         if(t>=1900)
_0x33:
	RCALL SUBOPT_0xF
	__CPD2N 0x76C
	BRLO _0x3B
; 0000 0259         {
; 0000 025A            menu=0;
	LDI  R30,LOW(0)
	RCALL SUBOPT_0x4
; 0000 025B           out=out1=out2=out3=out4=out5=out6=out7=out8=out9=0; // x
	RCALL SUBOPT_0xE
; 0000 025C         }
; 0000 025D     }
_0x3B:
; 0000 025E  }
_0x31:
	RET
;
;void main(void)
; 0000 0261 {
_main:
; 0000 0262 // Declare your local variables here
; 0000 0263 
; 0000 0264 // Input/Output Ports initialization
; 0000 0265 // Port A initialization
; 0000 0266 // Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out
; 0000 0267 // State7=1 State6=1 State5=1 State4=1 State3=1 State2=1 State1=1 State0=1
; 0000 0268 PORTA=0xFF;
	LDI  R30,LOW(255)
	OUT  0x1B,R30
; 0000 0269 DDRA=0xFF;
	OUT  0x1A,R30
; 0000 026A 
; 0000 026B // Port B initialization
; 0000 026C // Func7=In Func6=In Func5=In Func4=In Func3=Out Func2=Out Func1=Out Func0=Out
; 0000 026D // State7=T State6=T State5=T State4=T State3=0 State2=0 State1=0 State0=0
; 0000 026E PORTB=0x00;
	LDI  R30,LOW(0)
	OUT  0x18,R30
; 0000 026F DDRB=0x0F;
	LDI  R30,LOW(15)
	OUT  0x17,R30
; 0000 0270 
; 0000 0271 // Port C initialization
; 0000 0272 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
; 0000 0273 // State7=P State6=P State5=P State4=P State3=P State2=P State1=T State0=T
; 0000 0274 PORTC=0xFC;
	LDI  R30,LOW(252)
	OUT  0x15,R30
; 0000 0275 DDRC=0x00;
	LDI  R30,LOW(0)
	OUT  0x14,R30
; 0000 0276 
; 0000 0277 // Port D initialization
; 0000 0278 // Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=In Func0=In
; 0000 0279 // State7=0 State6=0 State5=0 State4=0 State3=0 State2=0 State1=T State0=T
; 0000 027A PORTD=0x00;
	OUT  0x12,R30
; 0000 027B DDRD=0xFC;
	LDI  R30,LOW(252)
	OUT  0x11,R30
; 0000 027C 
; 0000 027D // Timer/Counter 0 initialization
; 0000 027E // Clock source: System Clock
; 0000 027F // Clock value: Timer 0 Stopped
; 0000 0280 // Mode: Normal top=0xFF
; 0000 0281 // OC0 output: Disconnected
; 0000 0282 TCCR0=0x00;
	LDI  R30,LOW(0)
	OUT  0x33,R30
; 0000 0283 TCNT0=0x00;
	OUT  0x32,R30
; 0000 0284 OCR0=0x00;
	OUT  0x3C,R30
; 0000 0285 
; 0000 0286 // Timer/Counter 1 initialization
; 0000 0287 // Clock source: System Clock
; 0000 0288 // Clock value: Timer1 Stopped
; 0000 0289 // Mode: Normal top=0xFFFF
; 0000 028A // OC1A output: Discon.
; 0000 028B // OC1B output: Discon.
; 0000 028C // Noise Canceler: Off
; 0000 028D // Input Capture on Falling Edge
; 0000 028E // Timer1 Overflow Interrupt: Off
; 0000 028F // Input Capture Interrupt: Off
; 0000 0290 // Compare A Match Interrupt: Off
; 0000 0291 // Compare B Match Interrupt: Off
; 0000 0292 TCCR1A=0x00;
	OUT  0x2F,R30
; 0000 0293 TCCR1B=0x00;
	OUT  0x2E,R30
; 0000 0294 TCNT1H=0x00;
	OUT  0x2D,R30
; 0000 0295 TCNT1L=0x00;
	OUT  0x2C,R30
; 0000 0296 ICR1H=0x00;
	OUT  0x27,R30
; 0000 0297 ICR1L=0x00;
	OUT  0x26,R30
; 0000 0298 OCR1AH=0x00;
	OUT  0x2B,R30
; 0000 0299 OCR1AL=0x00;
	OUT  0x2A,R30
; 0000 029A OCR1BH=0x00;
	OUT  0x29,R30
; 0000 029B OCR1BL=0x00;
	OUT  0x28,R30
; 0000 029C 
; 0000 029D // Timer/Counter 2 initialization
; 0000 029E // Clock source: System Clock
; 0000 029F // Clock value: Timer2 Stopped
; 0000 02A0 // Mode: Normal top=0xFF
; 0000 02A1 // OC2 output: Disconnected
; 0000 02A2 ASSR=0x00;
	OUT  0x22,R30
; 0000 02A3 TCCR2=0x00;
	OUT  0x25,R30
; 0000 02A4 TCNT2=0x00;
	OUT  0x24,R30
; 0000 02A5 OCR2=0x00;
	OUT  0x23,R30
; 0000 02A6 
; 0000 02A7 // External Interrupt(s) initialization
; 0000 02A8 // INT0: Off
; 0000 02A9 // INT1: Off
; 0000 02AA // INT2: Off
; 0000 02AB MCUCR=0x00;
	OUT  0x35,R30
; 0000 02AC MCUCSR=0x00;
	OUT  0x34,R30
; 0000 02AD 
; 0000 02AE // Timer(s)/Counter(s) Interrupt(s) initialization
; 0000 02AF TIMSK=0x00;
	OUT  0x39,R30
; 0000 02B0 
; 0000 02B1 // USART initialization
; 0000 02B2 // Communication Parameters: 8 Data, 1 Stop, No Parity
; 0000 02B3 // USART Receiver: On
; 0000 02B4 // USART Transmitter: On
; 0000 02B5 // USART Mode: Asynchronous
; 0000 02B6 // USART Baud Rate: 9600
; 0000 02B7 UCSRA=0x00;
	OUT  0xB,R30
; 0000 02B8 UCSRB=0x18;
	LDI  R30,LOW(24)
	OUT  0xA,R30
; 0000 02B9 UCSRC=0x86;
	LDI  R30,LOW(134)
	OUT  0x20,R30
; 0000 02BA UBRRH=0x00;
	LDI  R30,LOW(0)
	OUT  0x20,R30
; 0000 02BB UBRRL=0x67;
	LDI  R30,LOW(103)
	OUT  0x9,R30
; 0000 02BC 
; 0000 02BD // Analog Comparator initialization
; 0000 02BE // Analog Comparator: Off
; 0000 02BF // Analog Comparator Input Capture by Timer/Counter 1: Off
; 0000 02C0 ACSR=0x80;
	LDI  R30,LOW(128)
	OUT  0x8,R30
; 0000 02C1 SFIOR=0x00;
	LDI  R30,LOW(0)
	OUT  0x30,R30
; 0000 02C2 
; 0000 02C3 // ADC initialization
; 0000 02C4 // ADC disabled
; 0000 02C5 ADCSRA=0x00;
	OUT  0x6,R30
; 0000 02C6 
; 0000 02C7 // SPI initialization
; 0000 02C8 // SPI disabled
; 0000 02C9 SPCR=0x00;
	OUT  0xD,R30
; 0000 02CA 
; 0000 02CB // TWI initialization
; 0000 02CC // TWI disabled
; 0000 02CD TWCR=0x00;
	OUT  0x36,R30
; 0000 02CE 
; 0000 02CF while (1)
_0x3C:
; 0000 02D0       {
; 0000 02D1       btn();
	RCALL _btn
; 0000 02D2       if(menu==0){ us();}
	LDS  R30,_menu
	CPI  R30,0
	BRNE _0x3F
	RCALL _us
; 0000 02D3        show_dig();
_0x3F:
	RCALL _show_dig
; 0000 02D4       }
	RJMP _0x3C
; 0000 02D5 }
_0x40:
	RJMP _0x40
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x40
	.EQU __sm_mask=0xB0
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0xA0
	.EQU __sm_ext_standby=0xB0
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif

	.CSEG

	.CSEG

	.CSEG

	.DSEG
_data:
	.BYTE 0x1
_input_us:
	.BYTE 0x34
_input_mem:
	.BYTE 0x34
_out1:
	.BYTE 0x1
_out2:
	.BYTE 0x1
_out3:
	.BYTE 0x1
_out4:
	.BYTE 0x1
_out5:
	.BYTE 0x1
_out6:
	.BYTE 0x1
_out7:
	.BYTE 0x1
_out8:
	.BYTE 0x1
_out9:
	.BYTE 0x1
_menu:
	.BYTE 0x1
_i:
	.BYTE 0x2
_t:
	.BYTE 0x4

	.CSEG
;OPTIMIZER ADDED SUBROUTINE, CALLED 10 TIMES, CODE SIZE REDUCTION:124 WORDS
SUBOPT_0x0:
	LDI  R26,LOW(5)
	MUL  R30,R26
	MOVW R30,R0
	SUBI R30,LOW(-_led_tab*2)
	SBCI R31,HIGH(-_led_tab*2)
	MOVW R26,R30
	MOV  R30,R4
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LPM  R30,Z
	COM  R30
	OUT  0x1B,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x1:
	LDI  R31,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x2:
	MOV  R26,R6
	LDI  R27,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x3:
	MOV  R30,R6
	RCALL SUBOPT_0x1
	SUBI R30,LOW(-_input_us)
	SBCI R31,HIGH(-_input_us)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x4:
	STS  _menu,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x5:
	STS  _out1,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x6:
	STS  _out2,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x7:
	STS  _out3,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x8:
	STS  _out4,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x9:
	STS  _out5,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0xA:
	STS  _out6,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0xB:
	STS  _out7,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0xC:
	STS  _out8,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0xD:
	STS  _out9,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:18 WORDS
SUBOPT_0xE:
	LDI  R30,LOW(0)
	RCALL SUBOPT_0xD
	RCALL SUBOPT_0xC
	RCALL SUBOPT_0xB
	RCALL SUBOPT_0xA
	RCALL SUBOPT_0x9
	RCALL SUBOPT_0x8
	RCALL SUBOPT_0x7
	RCALL SUBOPT_0x6
	RCALL SUBOPT_0x5
	MOV  R12,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:19 WORDS
SUBOPT_0xF:
	LDS  R26,_t
	LDS  R27,_t+1
	LDS  R24,_t+2
	LDS  R25,_t+3
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x10:
	LDS  R26,_i
	LDS  R27,_i+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 12 TIMES, CODE SIZE REDUCTION:9 WORDS
SUBOPT_0x11:
	LDS  R30,_i
	RET


	.CSEG
_delay_ms:
	ld   r30,y+
	ld   r31,y+
	adiw r30,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0xFA0
	wdr
	sbiw r30,1
	brne __delay_ms0
__delay_ms1:
	ret

__LSLB12:
	TST  R30
	MOV  R0,R30
	MOV  R30,R26
	BREQ __LSLB12R
__LSLB12L:
	LSL  R30
	DEC  R0
	BRNE __LSLB12L
__LSLB12R:
	RET

__GETD1P_INC:
	LD   R30,X+
	LD   R31,X+
	LD   R22,X+
	LD   R23,X+
	RET

__PUTDP1_DEC:
	ST   -X,R23
	ST   -X,R22
	ST   -X,R31
	ST   -X,R30
	RET

;END OF CODE MARKER
__END_OF_CODE:
